'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - DTC Printers                            **/
'/**                                                                       **/
'/**  MODULE NAME  : Info.vb                                               **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Partial Public Class Main

#Region "=== Local methods ==="

    Private Sub InitInfoTab()
        InitPasswordCombo()
    End Sub

    Private Sub ClearMsgBoxButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ClearMsgBoxButton.Click
        InfoMsgBox.Clear()
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Status ==="

    Private Sub PrinterStatusButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterStatusButton.Click
        Select Case SDK.ID_PrinterStatus(hSession)
            Case SDK.PrinterStatus.Ready
                InfoMsgBox.AppendText("Printer is READY" + Environment.NewLine)
            Case SDK.PrinterStatus.Offline
                InfoMsgBox.AppendText("Printer is OFFLINE" + Environment.NewLine)
            Case SDK.PrinterStatus.Error
                InfoMsgBox.AppendText("Printer is ERROR" + Environment.NewLine)
            Case Else
                InfoMsgBox.AppendText("Unknown Printer Status" + Environment.NewLine)
        End Select
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== PrinterInfo ==="

    Private Sub PrinterInfoButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterInfoButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim PrinterInfo As New SDK.PrinterInfo
        Dim SDKReturn As SDK.Return = SDK.ID_PrinterInfo(hSession, PrinterInfo)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("PrinterInfo", SDKReturn)
            Return
        End If

        InfoMsgBox.AppendText("PrinterConnected: " + PrinterInfo.bPrinterConnected.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("Model No.: " + PrinterInfo.eModel.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("Model: " + PrinterInfo.sModel + Environment.NewLine)
        InfoMsgBox.AppendText("PrintheadType: ")
        Select Case PrinterInfo.ePrintheadType
            Case 0
                InfoMsgBox.AppendText("KGE2" + Environment.NewLine)
            Case 1
                InfoMsgBox.AppendText("KEE1" + Environment.NewLine)
            Case 2
                InfoMsgBox.AppendText("KEE4" + Environment.NewLine)
            Case Else
                InfoMsgBox.AppendText("Unknown" + Environment.NewLine)
        End Select

        InfoMsgBox.AppendText("PrinterSerial: " + PrinterInfo.sPrinterSerial + Environment.NewLine)
        InfoMsgBox.AppendText("PrintheadSerial: " + PrinterInfo.sPrintheadSerial + Environment.NewLine)
        InfoMsgBox.AppendText("PCBSerial: " + PrinterInfo.sPCBSerial + Environment.NewLine)
        InfoMsgBox.AppendText("FirmwareVerion: " + PrinterInfo.Firmware.Version + Environment.NewLine)
        InfoMsgBox.AppendText("Density: " + PrinterInfo.iDensity.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("HandFeed: ")
        If PrinterInfo.iHandFeed <> 0 Then
            InfoMsgBox.AppendText("True" + Environment.NewLine)
        Else
            InfoMsgBox.AppendText("False" + Environment.NewLine)
        End If

        InfoMsgBox.AppendText("CardsPrinted: " + PrinterInfo.iCardsPrinted.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CardsOnPrinthead: " + PrinterInfo.iCardsOnPrinthead.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("DyePanelsPrinted: " + PrinterInfo.iDyePanelsPrinted.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CleansSinceShipped: " + PrinterInfo.iCleansSinceShipped.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("DyePanelsSinceClean: " + PrinterInfo.iDyePanelsSinceClean.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CardsSinceClean: " + PrinterInfo.iCardsSinceClean.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CardsBetweenCleans: " + PrinterInfo.iCardsBetweenCleans.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("PrintHeadPosn: " + PrinterInfo.iPrintHeadPosn.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ImageStartPosn: " + PrinterInfo.iImageStartPosn.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ImageEndPosn: " + PrinterInfo.iImageEndPosn.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("MajorError: " + PrinterInfo.iMajorError.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("MinorError: " + PrinterInfo.iMinorError.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("TagUID: " + PrinterInfo.sTagUID + Environment.NewLine)
        InfoMsgBox.AppendText("ShotsOnFilm: " + PrinterInfo.iShotsOnFilm.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ShotsUsed: " + PrinterInfo.iShotsUsed.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("DyeFilmType: " + PrinterInfo.sDyeFilmType + Environment.NewLine)
        InfoMsgBox.AppendText("DyeFilmManuf: " + PrinterInfo.eDyeFilmManuf.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ColourLength: " + PrinterInfo.iColourLength.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ResinLength: " + PrinterInfo.iResinLength.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("OvercoatLength: " + PrinterInfo.iOvercoatLength.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("DyeFlags: " + PrinterInfo.eDyeFlags.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CommandCode: " + PrinterInfo.iCommandCode.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("DOB: " + PrinterInfo.iDOB.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("DyeFilmProg: " + PrinterInfo.eDyeFilmProg.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("SmartMode: ")
        If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EncodePlaten) Then
            InfoMsgBox.AppendText(smartmodekp.Item(SDK.SmartMode.Platen) + Environment.NewLine)
        ElseIf PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EncodeXLI) Then
            InfoMsgBox.AppendText(smartmodekp.Item(SDK.SmartMode.XLI) + Environment.NewLine)
        Else
            InfoMsgBox.AppendText(smartmodekp.Item(SDK.SmartMode.Default) + Environment.NewLine)
        End If

        InfoMsgBox.AppendText("SmartOffset: " + PrinterInfo.iSmartOffset.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("EjectMode: ")
        If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EjectMode) Then
            InfoMsgBox.AppendText(ejectmodekp.Item(SDK.EjectMode.On) + Environment.NewLine)
        Else
            InfoMsgBox.AppendText(ejectmodekp.Item(SDK.EjectMode.Off) + Environment.NewLine)
        End If

        InfoMsgBox.AppendText("HorzEject: ")
        If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.HorzEject) Then
            InfoMsgBox.AppendText(horzejectkp.Item(SDK.HorzEject.On) + Environment.NewLine)
        Else
            InfoMsgBox.AppendText(horzejectkp.Item(SDK.HorzEject.Off) + Environment.NewLine)
        End If

        InfoMsgBox.AppendText("EraseSpeed: ")
        If PrinterInfo.iBitFields.HasFlag(SDK.InfoMask.EraseSpeed) Then
            InfoMsgBox.AppendText(erasespeedkp.Item(SDK.EraseSpeed.Quick) + Environment.NewLine)
        Else
            InfoMsgBox.AppendText(erasespeedkp.Item(SDK.EraseSpeed.Thorough) + Environment.NewLine)
        End If

        InfoMsgBox.AppendText(Environment.NewLine)

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== SDK Version ==="

    Private Sub SDKVersionButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles SDKVersionButton.Click
        Dim SDKVersion As New SDK.SDKVersion
        Dim SDKReturn As SDK.Return = SDK.ID_SDKVersion(hSession, SDKVersion)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("SDKVersion", SDKReturn)
        Else
            InfoMsgBox.AppendText("Version: " + SDKVersion.Major.ToString() _
                                  + "." + SDKVersion.Minor.ToString() _
                                  + "." + SDKVersion.Build.ToString() _
                                  + "." + SDKVersion.Private.ToString() _
                                  + Environment.NewLine)
            InfoMsgBox.AppendText(Environment.NewLine)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Connection Type === "

    Private Sub ConnectionTypeButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ConnectionTypeButton.Click
        Dim msg As String
        Select Case SDK.ID_ConnectionType(hSession)
            Case SDK.ConnectionType.USB
                msg = "USB"
            Case SDK.ConnectionType.Ethernet
                msg = "Ethernet"
            Case SDK.ConnectionType.File
                msg = "File"
            Case Else
                msg = "Unknown"
        End Select
        InfoMsgBox.AppendText("Connection Type: " + msg + Environment.NewLine)
        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Type ==="

    Private Sub PrinterTypeButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterTypeButton.Click
        InfoMsgBox.AppendText("Printer Type - ")
        Select Case printerType
            Case SDK.PrinterType.Rio
                InfoMsgBox.AppendText("RioTango" + Environment.NewLine)
            Case SDK.PrinterType.AOTA
                InfoMsgBox.AppendText("AOTA" + Environment.NewLine)
            Case SDK.PrinterType.Enduro
                InfoMsgBox.AppendText("Enduro Family" + Environment.NewLine)
            Case SDK.PrinterType.Ultima
                InfoMsgBox.AppendText("Ultima" + Environment.NewLine)
            Case SDK.PrinterType.Generation2
                InfoMsgBox.AppendText("Generation 2" + Environment.NewLine)
            Case Else
                InfoMsgBox.AppendText("UNKNOWN" + Environment.NewLine)
        End Select
        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Model ==="

    Private Sub PrinterModelButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterModelButton.Click

        Dim msg As String
        Dim model As SDK.Model = SDK.ID_PrinterModel(hSession)
        If model.HasFlag(SDK.Model.Pronto) Then
            msg = "Pronto"
        ElseIf model.HasFlag(SDK.Model.RioPro) Then
            msg = "Rio Pro"
        ElseIf model.HasFlag(SDK.Model.Ultima) Then
            msg = "Ultima"
        ElseIf model.HasFlag(SDK.Model.Enduro) Then
            msg = "Enduro"
        ElseIf model.HasFlag(SDK.Model.RioPro360) Then
            msg = "Rio Pro 360"
        ElseIf model.HasFlag(SDK.Model.Model600) Then
            msg = "600"
        ElseIf model.HasFlag(SDK.Model.Model300) Then
            msg = "300"
		ElseIf model.HasFlag(SDK.Model.Pronto100) Then
			msg = "Pronto 100"
        ElseIf model.HasFlag(SDK.Model.Generation2) Then
            msg = "Generation 2"
        Else
            msg = "Unknown"
        End If
        InfoMsgBox.AppendText("Printer - " + msg + Environment.NewLine)

        InfoMsgBox.AppendText("Capability:" + Environment.NewLine)
        If model.HasFlag(SDK.Model.Fn_Magnetic) Then
            InfoMsgBox.AppendText("  - Mag Encoding" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Duplex) Then
            InfoMsgBox.AppendText("  - Duplex" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Rewrite) Then
            InfoMsgBox.AppendText("  - Rewrite" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Chip) Then
            InfoMsgBox.AppendText("  - Chip Encoding" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Contactless) Then
            InfoMsgBox.AppendText("  - Contactless Encoding" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Extended) Then
            InfoMsgBox.AppendText("  - Extended" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Ethernet) Then
            InfoMsgBox.AppendText("  - Ethernet" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_600dpi) Then
            InfoMsgBox.AppendText("  - 600dpi" + Environment.NewLine)
        End If

        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== SDK Bits ==="

    Private Sub SDKBitsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SDKBitsButton.Click
        InfoMsgBox.AppendText(SDK.ID_SDKBits().ToString + " Bit SDK" + Environment.NewLine + Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Password ==="

    Private Sub PasswordBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PasswordCommand.SelectedIndexChanged
        If PasswordCommand.SelectedItem.Key() = SDK.Password.Use Then
            Pwd2Label.Enabled = False
            Password2.Enabled = False
        Else
            Pwd2Label.Enabled = True
            Password2.Enabled = True
        End If
    End Sub

    Dim passwordcmdkp As New Dictionary(Of SDK.Password, String) From
    {
        {SDK.Password.Set, "Set"},
        {SDK.Password.Use, "Use"}
    }

    Private Sub InitPasswordCombo()
        PasswordCommand.DataSource = New BindingSource(passwordcmdkp, Nothing)
        PasswordCommand.DisplayMember = "Value"
        PasswordCommand.SelectedItem = SDK.Password.Set
    End Sub

    Private Sub PasswordButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PasswordButton.Click
        Dim PasswordCmd As SDK.Password = PasswordCommand.SelectedItem.Key()

        Dim SDKReturn As SDK.Return = SDK.ID_Password(hSession, PasswordCmd, Password1.Text, Password2.Text)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("Password", SDKReturn)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== LastMessage ==="

    Private Sub LastMessageButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles LastMessageButton.Click
        Dim Temp As New StringBuilder
        Dim SDKReturn As SDK.Return = SDK.ID_LastMessage(hSession, Temp)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetLastMessage", SDKReturn)
        Else
            For Each c As Char In Temp.ToString()
                InfoMsgBox.AppendText(If(c = Chr(13), Environment.NewLine, c.ToString()))
            Next

            InfoMsgBox.AppendText(Environment.NewLine)
            InfoMsgBox.AppendText(Environment.NewLine)
        End If

    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Pro360 Parameters ==="

    Private Enum ParamType
        AsBool
        AsInt
        AsString
    End Enum

    Private Structure ParamSet
        Public Text As String
        Public ID As SDK.Pro360Param
        Public Type As ParamType

        ' constructor
        Public Sub New( _
           ByVal x As String, ByVal y As SDK.Pro360Param, ByVal z As ParamType)
            Text = x
            ID = y
            Type = z
        End Sub
    End Structure

    Dim paramTable As New List(Of ParamSet) From {
        New ParamSet("Duplex", SDK.Pro360Param.CapabilityDuplex, ParamType.AsBool),
        New ParamSet("Mag Encoding", SDK.Pro360Param.CapabilityMag, ParamType.AsBool),
        New ParamSet("Smart Encoding", SDK.Pro360Param.CapabilitySmart, ParamType.AsBool),
        New ParamSet("System Version", SDK.Pro360Param.SystemVersion, ParamType.AsString),
        New ParamSet("Printer App Version", SDK.Pro360Param.PrinterAppVersion, ParamType.AsString),
        New ParamSet("Firmware Version", SDK.Pro360Param.FirmwareVersion, ParamType.AsString),
        New ParamSet("Mag Firmware Version", SDK.Pro360Param.MagFirmwareVersion, ParamType.AsString),
        New ParamSet("Printer Serial", SDK.Pro360Param.PrinterSerial, ParamType.AsString),
        New ParamSet("Printhead Serial", SDK.Pro360Param.PrintheadSerial, ParamType.AsString),
        New ParamSet("Main Board Serial", SDK.Pro360Param.BoardSerial, ParamType.AsString),
        New ParamSet("Model Name", SDK.Pro360Param.ModelName, ParamType.AsString),
        New ParamSet("Dealer Code", SDK.Pro360Param.DealerCode, ParamType.AsInt),
        New ParamSet("Project Code", SDK.Pro360Param.ProjectCode, ParamType.AsInt),
        New ParamSet("Total Cards", SDK.Pro360Param.TotalCards, ParamType.AsInt),
        New ParamSet("Total Panels", SDK.Pro360Param.TotalPanels, ParamType.AsInt),
        New ParamSet("Cards on Printhead", SDK.Pro360Param.CardsOnPrinthead, ParamType.AsInt),
        New ParamSet("Panels on Printhead", SDK.Pro360Param.PanelsOnPrinthead, ParamType.AsInt),
        New ParamSet("Cards since Clean", SDK.Pro360Param.CardsSinceClean, ParamType.AsInt),
        New ParamSet("Panels since Clean", SDK.Pro360Param.PanelsSinceClean, ParamType.AsInt),
        New ParamSet("Cleaning Cycles", SDK.Pro360Param.Cleans, ParamType.AsInt),
        New ParamSet("Dyefilm Name", SDK.Pro360Param.DyeFilmName, ParamType.AsString),
        New ParamSet("Dyefilm Serial", SDK.Pro360Param.DyeFilmSerial, ParamType.AsString),
        New ParamSet("Dyefilm Prints", SDK.Pro360Param.DyeFilmTotalPrints, ParamType.AsInt),
        New ParamSet("Dyefilm Prints Left", SDK.Pro360Param.DyeFilmPrintsRemaining, ParamType.AsInt),
        New ParamSet("Dyefilm Manufacturer", SDK.Pro360Param.DyeFilmManufacturer, ParamType.AsInt),
        New ParamSet("Dyefilm YMC Length", SDK.Pro360Param.ColourLength, ParamType.AsInt),
        New ParamSet("Dyefilm K Length", SDK.Pro360Param.BlackLength, ParamType.AsInt),
        New ParamSet("Dyefilm O Length", SDK.Pro360Param.OverlayLength, ParamType.AsInt),
        New ParamSet("Cards between Cleans", SDK.Pro360Param.CleansInterval, ParamType.AsInt),
        New ParamSet("Clean Overdue", SDK.Pro360Param.CleanOverdue, ParamType.AsBool),
        New ParamSet("MAC Address", SDK.Pro360Param.MACAddress, ParamType.AsString),
        New ParamSet("Use DHCP", SDK.Pro360Param.UseDHCP, ParamType.AsBool),
        New ParamSet("IP Address", SDK.Pro360Param.DynamicIPAddress, ParamType.AsString),
        New ParamSet("IP Gateway", SDK.Pro360Param.DynamicGateway, ParamType.AsString),
        New ParamSet("IP Subnet", SDK.Pro360Param.DynamicSubnet, ParamType.AsString),
        New ParamSet("Static IP Address", SDK.Pro360Param.StaticIPAddress, ParamType.AsString),
        New ParamSet("Static IP Gateway", SDK.Pro360Param.StaticGateway, ParamType.AsString),
        New ParamSet("Static IP Subnet", SDK.Pro360Param.StaticSubnet, ParamType.AsString),
        New ParamSet("Error Status", SDK.Pro360Param.ErrorCode, ParamType.AsString),
        New ParamSet("Hand Feed", SDK.Pro360Param.HandFeed, ParamType.AsBool),
        New ParamSet("Card Position", SDK.Pro360Param.CardLocation, ParamType.AsString),
        New ParamSet("Mag Encoding Start", SDK.Pro360Param.MagStart, ParamType.AsInt),
        New ParamSet("Contactless Offset", SDK.Pro360Param.SmartOffset, ParamType.AsInt),
        New ParamSet("HoloKote Slots", SDK.Pro360Param.HoloKoteCount, ParamType.AsInt),
        New ParamSet("600 dpi", SDK.Pro360Param.Resolution600dpi, ParamType.AsBool),
        New ParamSet("Hopper Sensor", SDK.Pro360Param.SensorHopper, ParamType.AsBool),
        New ParamSet("Exit Sensor", SDK.Pro360Param.SensorExit, ParamType.AsBool),
        New ParamSet("Lid Sensor", SDK.Pro360Param.SensorLid, ParamType.AsBool),
        New ParamSet("Manufacturer", SDK.Pro360Param.Manufacturer, ParamType.AsString),
        New ParamSet("Hopper Sensor Fitted", SDK.Pro360Param.HopperSensorFitted, ParamType.AsBool),
        New ParamSet("Exit Sensor Fitted", SDK.Pro360Param.ExitSensorFitted, ParamType.AsBool),
        New ParamSet("Region", SDK.Pro360Param.Region, ParamType.AsInt)
    }

    Private Sub ReadParamButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ReadParamButton.Click
        Dim SDKReturn As SDK.Return
        Dim tempString As String = ""
        Dim param As ParamSet = paramTable(ParamCombo.SelectedIndex)

        Select Case param.Type
            Case ParamType.AsInt
                Dim temp As New Integer
                SDKReturn = SDK.ID_AccessInt(hSession, SDK.Action.Read, param.ID, temp)
                tempString = temp.ToString()
            Case ParamType.AsBool
                Dim temp As New Boolean
                SDKReturn = SDK.ID_AccessBool(hSession, SDK.Action.Read, param.ID, temp)
                tempString = If(temp, "TRUE", "FALSE")
            Case Else
                Dim temp As New StringBuilder
                SDKReturn = SDK.ID_AccessString(hSession, SDK.Action.Read, param.ID, temp)
                tempString = temp.ToString()
        End Select

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetParam", SDKReturn)
        Else
            InfoMsgBox.AppendText(param.Text _
                                  + Separator(SDK.Action.Read) _
                                  + tempString _
                                  + Environment.NewLine)
            InfoMsgBox.AppendText(Environment.NewLine)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Pro360 All Params ==="

    Private Sub AllParamsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles AllParamsButton.Click
        Dim SDKReturn As SDK.Return
        Dim tempString As String = ""

        For Each param As ParamSet In paramTable
            Select Case param.Type
                Case ParamType.AsInt
                    Dim temp As New Integer
                    SDKReturn = SDK.ID_AccessInt(hSession, SDK.Action.Read, param.ID, temp)
                    tempString = temp.ToString()
                Case ParamType.AsBool
                    Dim temp As New Boolean
                    SDKReturn = SDK.ID_AccessBool(hSession, SDK.Action.Read, param.ID, temp)
                    tempString = If(temp, "TRUE", "FALSE")
                Case Else
                    Dim temp As New StringBuilder
                    SDKReturn = SDK.ID_AccessString(hSession, SDK.Action.Read, param.ID, temp)
                    tempString = temp.ToString()
            End Select

            If SDKReturn <> SDK.Return.Success Then
                HandleError("GetAllParam", SDKReturn)
            Else
                InfoMsgBox.AppendText(param.Text _
                                      + Separator(SDK.Action.Read) _
                                      + tempString _
                                      + Environment.NewLine)
            End If
        Next
        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Sensors ==="

    Private Sub SensorsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SensorsButton.Click

        Cursor.Current = Cursors.WaitCursor

        Dim response As SDK.Sensors = 0
        Dim SDKReturn As SDK.Return = SDK.ID_Sensors(hSession, response)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("Sensors", SDKReturn)
        Else
            InfoMsgBox.AppendText("Sensors:" + Environment.NewLine)
            If response.HasFlag(SDK.Sensors.Lid) Then
                InfoMsgBox.AppendText("- Lid Closed" + Environment.NewLine)
            Else
                InfoMsgBox.AppendText("- Lid Open" + Environment.NewLine)
            End If

            If response.HasFlag(SDK.Sensors.HopperValid) Then
                InfoMsgBox.AppendText("- Hopper Sensor Not Fitted\n" + Environment.NewLine)
            ElseIf response.HasFlag(SDK.Sensors.Hopper) Then
                InfoMsgBox.AppendText("- Cards in Hopper" + Environment.NewLine)
            Else
                InfoMsgBox.AppendText("- Cards Low" + Environment.NewLine)
            End If

            If response.HasFlag(SDK.Sensors.ExitValid) Then
                InfoMsgBox.AppendText("- Exit Sensor Not Fitted\n")
            ElseIf response.HasFlag(SDK.Sensors.Exit) Then
                InfoMsgBox.AppendText("- Exit Blocked" + Environment.NewLine)
            Else
                InfoMsgBox.AppendText("- Exit Clear")
            End If

            InfoMsgBox.AppendText(Environment.NewLine)
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

End Class
